<?php
//test
//
//header("Access-Control-Allow-Credentials: true");
$allowedOrigins = [
    "https://website.prag.corexx.in",
    "https://webadmin.prag.corexx.in",
    "https://pragjyotishcollege.ac.in",
    "https://www.pragjyotishcollege.ac.in",
    "http://pragjyotishcollege.ac.in",
    "https://webadmin.pragjyotishcollege.ac.in",
    "https://www.webadmin.pragjyotishcollege.ac.in",
    "http://localhost:3000",
    "http://localhost:3001",
    "http://localhost:3002",
    "http://localhost:3003",
    "http://localhost:4200",
];

if (in_array($_SERVER["HTTP_ORIGIN"], $allowedOrigins)) {
    header("Access-Control-Allow-Origin: " . $_SERVER["HTTP_ORIGIN"]);
}
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Unit, Authorization");
//header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization");
//
if($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
   header( "HTTP/1.1 200 OK" );
   exit();
}  
// --(REMOVE THE ABOVE CODE IN PRODUCTION SERVER) --> Place-3 
// 

date_default_timezone_set("Asia/Kolkata");



//history enabling and disabling can be done here 
define('SITE_HISTORY_KEEPING', 'ENABLED');  
    //put 'DISABLED' to skip history storing, and put 'ENABLED' to keep data in history 



require __DIR__ . '/../vendor/autoload.php';



//load environment variables
$dotenv = new Dotenv\Dotenv(__DIR__);
$r = $dotenv->load();

// define a constant globally



// Instantiate the app
require __DIR__ . '/../src/config.php';
$app = new \Slim\App(['settings' => $config]);

// Set up dependencies
require __DIR__ . '/../src/dependencies.php';

// Set up authentication routes
require __DIR__ . '/../src/routes/auth.php';

// Register middleware
require __DIR__ . '/../src/middleware.php';

// we will need utilities 
require __DIR__ . '/../src/utility.php';
require __DIR__ . '/../src/routes/addfile.php';
require __DIR__ . '/../src/routes/college_user.php';
require __DIR__ . '/../src/routes/deletefile.php';
require __DIR__ . '/../src/routes/initialisation.php';
require __DIR__ . '/../src/routes/notices.php';
require __DIR__ . '/../src/routes/department.php';
require __DIR__ . '/../src/routes/department_file.php';
require __DIR__ . '/../src/routes/employee.php';
require __DIR__ . '/../src/routes/alumni.php';
require __DIR__ . '/../src/routes/committee.php';
require __DIR__ . '/../src/routes/iqac.php';
require __DIR__ . '/../src/routes/iqacssr.php';
require __DIR__ . '/../src/routes/gallery.php';
require __DIR__ . '/../src/routes/featured_notification.php';
require __DIR__ . '/../src/routes/visitornote.php';


/**
 * Verifying required params posted or not
 */
function verifyRequiredParams($required_fields,$request_params) {
    $error = false;
    $error_fields = "";
    foreach ($required_fields as $field) {
        if (!isset($request_params->$field) || strlen(trim($request_params->$field)) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }
    if ($error) {  // 
        return $error_fields;
    } else {
        return false;
    }
}



$app->run();
